-- Fichero Baskedes.sql
-------------------------------------------------------------------
-- Borrar TABLAS de la Base de Datos DIFUSA de Baloncesto y      --
-- borrar los elementos en la FMB de esta Bd (etiquetas...)      --
-------------------------------------------------------------------
-- Para que salgan los mensajes (de put_line) al instalar desde FSQL*Plus:
set serveroutput on
-- Para que salgan (o no) las ordenes a ejecutar: set echo on
set echo off
-- Para que no salgan los mensajes cuando todo va bien (los errores si salen):
set feedback off

exec dbms_output.put_line('>>>>');
exec dbms_output.put_line('>>>> ******************************************** <<<<');
exec dbms_output.put_line('>>>> **** DESINSTALACIN de la Base de Datos **** <<<<');
exec dbms_output.put_line('>>>> **** Difusa de ejemplo sobre Baloncesto **** <<<<');
exec dbms_output.put_line('>>>> ******************************************** <<<<');
exec dbms_output.put_line('>>>>');

DECLARE
  t_PLAYERS NUMBER;
  t_SEARCH  NUMBER;
BEGIN
  -- Calcular OBJ# para las tablas con columnas difusas:
  SELECT object_id into t_PLAYERS FROM user_objects WHERE object_name='PLAYERS';
  SELECT object_id into t_SEARCH  FROM user_objects WHERE object_name='SEARCH';

  -- Atributos con tratamiento difuso: Tipos 1, 2  3.
  DELETE FROM FCL WHERE OBJ#=t_PLAYERS;
  DELETE FROM FCL WHERE OBJ#=t_SEARCH;

  DELETE FROM FOL WHERE OBJ#=t_PLAYERS;
  DELETE FROM FOL WHERE OBJ#=t_SEARCH;

  DELETE FROM FLD WHERE OBJ#=t_PLAYERS;
  DELETE FROM FLD WHERE OBJ#=t_SEARCH;

  DELETE FROM FAM WHERE OBJ#=t_PLAYERS;
  DELETE FROM FAM WHERE OBJ#=t_SEARCH;
  COMMIT;
END;
/

-- Borrar tablas
DROP TABLE PLAYERS;
DROP TABLE SEARCH;
COMMIT;

-- Mensaje de FIN:
exec dbms_output.put_line('>>>>');
exec dbms_output.put_line('>>>> FIN de la DESINSTALACIN: Si existieron errores, revise su texto.');
exec dbms_output.put_line('>>>>');

-- Reestablecer los valores por defecto:
set serveroutput off
set feedback on
